/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.fileLookup;

import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MemorizingLookup<K, V, P> {
    @NotNull
    private final Iterable<P> myWhere;
    @NotNull
    private final Iterator<P> myPlaceIterator;
    @NotNull
    private final LinkedList<P> myVisitedPlaces;

    protected MemorizingLookup(@NotNull Iterable<P> where) {
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "jetbrains/buildServer/util/fileLookup/MemorizingLookup", "<init>"));
        }
        this.myVisitedPlaces = new LinkedList();
        this.myWhere = where;
        this.myPlaceIterator = where.iterator();
    }

    @Nullable
    public V lookup(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/fileLookup/MemorizingLookup", "lookup"));
        }
        V found = this.lookupInVisited(key);
        if (found != null) {
            return found;
        }
        if (!this.hasNewPlaces()) {
            return null;
        }
        return this.lookupInNew(key);
    }

    @Nullable
    private V lookupInVisited(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/fileLookup/MemorizingLookup", "lookupInVisited"));
        }
        Iterator it = this.myVisitedPlaces.iterator();
        V found = null;
        Object where = null;
        while (it.hasNext()) {
            Object place = it.next();
            found = this.lookupInside(place, key);
            if (found == null) continue;
            where = place;
            it.remove();
            break;
        }
        if (where != null) {
            this.myVisitedPlaces.addFirst(where);
        }
        return found;
    }

    private boolean hasNewPlaces() {
        return this.myPlaceIterator.hasNext();
    }

    @Nullable
    private V lookupInNew(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/fileLookup/MemorizingLookup", "lookupInNew"));
        }
        if (!this.hasNewPlaces()) {
            return null;
        }
        V found = null;
        while (this.myPlaceIterator.hasNext()) {
            P place = this.myPlaceIterator.next();
            found = this.lookupInside(place, key);
            if (found == null) {
                this.myVisitedPlaces.add(place);
                continue;
            }
            this.myVisitedPlaces.addFirst(place);
            break;
        }
        return found;
    }

    @Nullable
    public V lookupExhaustive(@NotNull K key) {
        P place;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/fileLookup/MemorizingLookup", "lookupExhaustive"));
        }
        V found = null;
        Iterator<P> i$ = this.myWhere.iterator();
        while (i$.hasNext() && (found = (V)this.lookupInside(place = i$.next(), key)) == null) {
        }
        return found;
    }

    @Nullable
    protected abstract V lookupInside(@NotNull P var1, @NotNull K var2);
}

