/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtil {
    private FilterUtil() {
    }

    @NotNull
    public static <T> Filter<T> not(final @NotNull Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/filters/FilterUtil", "not"));
        }
        Filter filter2 = new Filter<T>(){

            @Override
            public boolean accept(@NotNull T data) {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/filters/FilterUtil$1", "accept"));
                }
                return !filter.accept(data);
            }
        };
        if (filter2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/filters/FilterUtil", "not"));
        }
        return filter2;
    }

    @NotNull
    public static <T> Filter<T> and(final Filter<? super T> ... filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "jetbrains/buildServer/util/filters/FilterUtil", "and"));
        }
        for (Filter<? super T> filter : filters) {
            if (filter != null) continue;
            throw new IllegalArgumentException("All specified filters must not be null");
        }
        Filter filter = new Filter<T>(){

            @Override
            public boolean accept(@NotNull T data) {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/filters/FilterUtil$2", "accept"));
                }
                for (Filter filter : filters) {
                    if (filter.accept(data)) continue;
                    return false;
                }
                return true;
            }
        };
        if (filter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/filters/FilterUtil", "and"));
        }
        return filter;
    }

    public static <E, T extends Collection<? extends E>> T filterCollection(@NotNull T collection, @NotNull Filter<E> filter) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/filters/FilterUtil", "filterCollection"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/filters/FilterUtil", "filterCollection"));
        }
        if (collection instanceof ArrayList) {
            return (T)FilterUtil.filterArrayList((ArrayList)collection, filter);
        }
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            E e = it.next();
            boolean accepted = e != null && filter.accept(e);
            if (accepted) continue;
            it.remove();
        }
        return collection;
    }

    @NotNull
    public static <E, T extends E> ArrayList<T> filterArrayList(@NotNull ArrayList<T> original, @NotNull Filter<E> filter) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "jetbrains/buildServer/util/filters/FilterUtil", "filterArrayList"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/filters/FilterUtil", "filterArrayList"));
        }
        ArrayList<T> result = null;
        for (int i = 0; i < original.size(); ++i) {
            boolean accepted;
            T t = original.get(i);
            boolean bl = accepted = t != null && filter.accept(t);
            if (accepted) {
                if (result == null) continue;
                result.add(t);
                continue;
            }
            if (result != null) continue;
            result = new ArrayList<T>(original.size() - 1);
            result.addAll(original.subList(0, i));
        }
        if (result != null) {
            original.clear();
            original.addAll(result);
        }
        ArrayList<T> arrayList = original;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/filters/FilterUtil", "filterArrayList"));
        }
        return arrayList;
    }

    @NotNull
    public static <Key, Value, T extends Map<Key, Value>> T filterMapByKey(@NotNull T map, @NotNull Filter<? super Key> filter) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/filters/FilterUtil", "filterMapByKey"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/filters/FilterUtil", "filterMapByKey"));
        }
        Iterator<Key> it = map.keySet().iterator();
        while (it.hasNext()) {
            Key key = it.next();
            if (filter.accept(key)) continue;
            it.remove();
        }
        T t = map;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/filters/FilterUtil", "filterMapByKey"));
        }
        return t;
    }

    public static <Key, Value, T extends Map<Key, Value>> T filterMapByValue(@NotNull T map, @NotNull Filter<Value> filter) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/filters/FilterUtil", "filterMapByValue"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/filters/FilterUtil", "filterMapByValue"));
        }
        Iterator<Key> it = map.keySet().iterator();
        while (it.hasNext()) {
            Key key = it.next();
            Value val = map.get(key);
            if (filter.accept(val)) continue;
            it.remove();
        }
        return map;
    }

    public static <Key, Value, Source extends Map<? extends Key, ? extends Value>, Target extends Map<? super Key, ? super Value>> Target filterMapByKeyAndCopy(@NotNull Source sourceMap, @NotNull Target targetMap, @NotNull Filter<? super Key> filter) {
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMap", "jetbrains/buildServer/util/filters/FilterUtil", "filterMapByKeyAndCopy"));
        }
        if (targetMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMap", "jetbrains/buildServer/util/filters/FilterUtil", "filterMapByKeyAndCopy"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/filters/FilterUtil", "filterMapByKeyAndCopy"));
        }
        for (Map.Entry<Key, Value> entry : sourceMap.entrySet()) {
            Key key = entry.getKey();
            if (!filter.accept(key)) continue;
            targetMap.put(key, entry.getValue());
        }
        return targetMap;
    }

    public static <C extends Collection<? super T>, T> C filterAndCopy(@NotNull Iterable<T> source, @NotNull C target, @NotNull Filter<? super T> filter) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/util/filters/FilterUtil", "filterAndCopy"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "jetbrains/buildServer/util/filters/FilterUtil", "filterAndCopy"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/filters/FilterUtil", "filterAndCopy"));
        }
        for (T k : source) {
            if (!filter.accept(k)) continue;
            target.add(k);
        }
        return target;
    }
}

