/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.positioning;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.dataStructures.MultiMapToSet;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.positioning.PositionConstraint;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionAwareSortedCollection<T> {
    private static final Logger LOG = Logger.getInstance((String)PositionAwareSortedCollection.class.getName());
    private final Collection<Node<T>> myFirstNodes = new ArrayList<Node<T>>();
    private final Collection<Node<T>> myLastNodes = new ArrayList<Node<T>>();
    private final Collection<Node<T>> myNodes = new ArrayList<Node<T>>();
    private final MultiMapToSet<String, String> myBeforeConstraints = new MultiMapToSet();
    private final Set<String> myIds = new HashSet<String>();
    private final Set<String> myNotExisting = new HashSet<String>();
    private final Function<Node<T>, String> NODE_TO_STRING = new Function<Node<T>, String>(){

        public String fun(Node<T> node) {
            return node.getId();
        }
    };

    public void add(@NotNull T item, @NotNull String id, @NotNull PositionConstraint constraint) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "add"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "add"));
        }
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "add"));
        }
        Node<T> node = new Node<T>(item, id);
        this.myIds.add(id);
        this.myNotExisting.remove(id);
        if (constraint.isFirst()) {
            this.myFirstNodes.add(node);
            return;
        }
        if (constraint.isLast()) {
            this.myLastNodes.add(node);
            return;
        }
        this.myNodes.add(node);
        for (String s : constraint.getBefore()) {
            this.myBeforeConstraints.add(s, id);
            if (this.myIds.contains(s)) continue;
            this.myNotExisting.add(s);
        }
        for (String s : constraint.getAfter()) {
            this.myBeforeConstraints.add(id, s);
            if (this.myIds.contains(s)) continue;
            this.myNotExisting.add(s);
        }
    }

    public boolean removeWhere(@NotNull Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "removeWhere"));
        }
        boolean found = false;
        for (Collection nodes : Arrays.asList(this.myFirstNodes, this.myLastNodes, this.myNodes)) {
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!filter.accept(node.getItem())) continue;
                found = true;
                it.remove();
                String id = node.getId();
                this.myIds.remove(id);
                this.myBeforeConstraints.removeValue(id);
                this.myBeforeConstraints.removeKey(id);
            }
        }
        return found;
    }

    public boolean isEmpty() {
        return this.myIds.isEmpty();
    }

    public int size() {
        return this.myLastNodes.size() + this.myFirstNodes.size() + this.myNodes.size();
    }

    public void clear() {
        this.myFirstNodes.clear();
        this.myLastNodes.clear();
        this.myNodes.clear();
        this.myIds.clear();
        this.myBeforeConstraints.clear();
    }

    @NotNull
    public List<T> getSorted() {
        if (this.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "getSorted"));
            }
            return list;
        }
        LinkedList<Node<T>> nodes = new LinkedList<Node<T>>(this.myNodes);
        ArrayList<Node<T>> result = new ArrayList<Node<T>>(this.size());
        HashSet<String> added = new HashSet<String>(3 * this.size() + this.myNotExisting.size() * 2);
        added.addAll(this.myNotExisting);
        for (Node<T> note : this.myFirstNodes) {
            added.add(note.getId());
        }
        while (!nodes.isEmpty()) {
            boolean mayContinue = false;
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!added.containsAll(this.myBeforeConstraints.getValues(node.getId()))) continue;
                it.remove();
                this.addNodeToResult(result, added, node);
                mayContinue = true;
                break;
            }
            if (mayContinue || nodes.size() <= 0) continue;
            LOG.warn("Dependency cycle detected among ordered items: " + this.nodesToString(nodes) + ", order is unpredictable");
            Node<T> node = nodes.remove(0);
            this.addNodeToResult(result, added, node);
        }
        this.myNodes.clear();
        this.myNodes.addAll(result);
        List<T> list = this.createResultCollection(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "getSorted"));
        }
        return list;
    }

    private String nodesToString(List<Node<T>> nodes) {
        if (nodes.isEmpty()) {
            return "<empty>";
        }
        return StringUtil.join(nodes, this.NODE_TO_STRING, (String)", ");
    }

    @NotNull
    private List<T> createResultCollection(@NotNull List<Node<T>> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "createResultCollection"));
        }
        ArrayList items = new ArrayList(this.size());
        for (Collection nodes : Arrays.asList(this.myFirstNodes, result, this.myLastNodes)) {
            for (Node node : nodes) {
                items.add(node.getItem());
            }
        }
        ArrayList arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "createResultCollection"));
        }
        return arrayList;
    }

    private void addNodeToResult(@NotNull Collection<Node<T>> result, @NotNull Set<String> added, @NotNull Node<T> node) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "addNodeToResult"));
        }
        if (added == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "added", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "addNodeToResult"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection", "addNodeToResult"));
        }
        added.add(node.getId());
        result.add(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        private final String myId;
        private final T myItem;

        public Node(@NotNull T item, @NotNull String id) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node", "<init>"));
            }
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node", "<init>"));
            }
            this.myItem = item;
            this.myId = id;
        }

        @NotNull
        public T getItem() {
            T t = this.myItem;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node", "getItem"));
            }
            return t;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node", "getId"));
            }
            return string;
        }

        public String toString() {
            return "Node{myId='" + this.myId + '\'' + '}';
        }
    }
}

