/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStringUtil;
import jetbrains.buildServer.vcs.FileRuleSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRule<ParentRules extends FileRuleSet> {
    protected final String myFromPath;
    protected final String myFromFull;
    private final ParentRules myParentRules;
    protected final Pattern myPattern;
    private final boolean myIsInclude;
    private static final String STANDARD_TAIL = "(\\/.*)*";
    private Map<String, String> myAdditionalProperties;

    public FileRule(@NotNull String from, ParentRules parentRules, boolean isInclude) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "jetbrains/buildServer/vcs/FileRule", "<init>"));
        }
        this(from, parentRules, isInclude, true);
    }

    public FileRule(@NotNull String from, ParentRules parentRules, boolean isInclude, boolean usePattern) {
        String fromPath;
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "jetbrains/buildServer/vcs/FileRule", "<init>"));
        }
        this.myParentRules = parentRules;
        this.myIsInclude = isInclude;
        this.myFromFull = StringUtil.emptyIfNull(from);
        if (from.startsWith("+:") || from.startsWith("-:")) {
            from = from.substring(2);
        }
        if (from.contains(":")) {
            from = this.readAdditionalProperties(from).trim();
        }
        if ((fromPath = this.preparePath(from)).equals(this.myFromFull)) {
            fromPath = this.myFromFull;
        }
        this.myFromPath = StringUtil.emptyIfNull(fromPath);
        this.myPattern = usePattern ? this.compilePattern() : null;
    }

    @Nullable
    private Pattern compilePattern() {
        if (this.myFromPath.endsWith("*") || this.myFromPath.endsWith("**")) {
            return Pattern.compile(this.createPatternString(this.myFromPath));
        }
        if (this.myFromPath.length() == 0) {
            return null;
        }
        return Pattern.compile(this.createPatternString(this.myFromPath) + STANDARD_TAIL);
    }

    public FileRule(@NotNull String fromPath, @Nullable String additionalProperties, ParentRules parentRules, boolean isInclude) {
        if (fromPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPath", "jetbrains/buildServer/vcs/FileRule", "<init>"));
        }
        this.myParentRules = parentRules;
        this.myIsInclude = isInclude;
        this.myFromPath = this.preparePath(fromPath);
        this.myFromFull = fromPath + (additionalProperties == null ? "" : ":" + additionalProperties);
        this.myPattern = this.compilePattern();
    }

    @NotNull
    private String readAdditionalProperties(@NotNull String from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "jetbrains/buildServer/vcs/FileRule", "readAdditionalProperties"));
        }
        int lastSeparator = from.lastIndexOf(":");
        String properties = from.substring(0, lastSeparator);
        this.myAdditionalProperties = TCStringUtil.readProperties(properties, ";", "=");
        String string = this.myAdditionalProperties.size() > 0 ? from.substring(lastSeparator + 1) : from;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/FileRule", "readAdditionalProperties"));
        }
        return string;
    }

    @NotNull
    protected String createPatternString(@NotNull String from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "jetbrains/buildServer/vcs/FileRule", "createPatternString"));
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < from.length(); ++i) {
            char nextChar = from.charAt(i);
            if (nextChar == '\\') {
                result.append("\\/");
                continue;
            }
            if (nextChar == '?') {
                result.append(".");
                continue;
            }
            if (nextChar == '$' || nextChar == '(' || nextChar == '{' || nextChar == ')' || nextChar == '}' || nextChar == '[' || nextChar == ']' || nextChar == '/' || nextChar == '.' || nextChar == '+') {
                result.append("\\").append(nextChar);
                continue;
            }
            if (nextChar == '*') {
                if (i < from.length() - 1 && from.charAt(i + 1) == '*') {
                    result.append("(.*)");
                    ++i;
                    continue;
                }
                result.append("([^/]*)");
                continue;
            }
            result.append(nextChar);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/FileRule", "createPatternString"));
        }
        return string;
    }

    public String getFrom() {
        return this.myFromPath;
    }

    public ParentRules getParentRules() {
        return this.myParentRules;
    }

    public boolean isIsInclude() {
        return this.myIsInclude;
    }

    public String toString() {
        if (this.myIsInclude) {
            return this.myFromFull;
        }
        return "-:" + this.myFromFull;
    }

    @Nullable
    public String getMatchedHead(String path) {
        if (this.myPattern == null) {
            return "";
        }
        Matcher matcher = this.myPattern.matcher(path);
        if (matcher.matches()) {
            int groupCount = matcher.groupCount();
            String lastGroup = matcher.group(groupCount);
            if (lastGroup != null) {
                return this.preparePath(path.substring(0, path.length() - lastGroup.length()));
            }
            return this.preparePath(path);
        }
        return null;
    }

    @Nullable
    public String getProperty(String propName) {
        if (this.myAdditionalProperties == null) {
            return null;
        }
        return this.myAdditionalProperties.get(propName);
    }

    public boolean propertiesMatch(Map<String, String> props) {
        if (this.myAdditionalProperties == null) {
            return true;
        }
        for (String name : this.myAdditionalProperties.keySet()) {
            String expectedProp = this.myAdditionalProperties.get(name);
            String actualProp = props.get(name);
            if (expectedProp == null || expectedProp.equals(actualProp)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Map<String, String> getAdditionalProperties() {
        return this.myAdditionalProperties;
    }

    public boolean isAbsolutePath() {
        return this.myFromFull.startsWith("/");
    }

    public boolean isRoot() {
        return StringUtil.isEmpty((String)this.myFromPath) && (this.myAdditionalProperties == null || this.myAdditionalProperties.isEmpty());
    }

    @NotNull
    protected String preparePath(@Nullable String path) {
        ParentRules parentRules = this.getParentRules();
        String string = parentRules == null ? FileRule.prepareRulePath(path) : ((FileRuleSet)parentRules).preparePath(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/FileRule", "preparePath"));
        }
        return string;
    }

    @NotNull
    private static String prepareRulePath(@Nullable String path) {
        if (path == null || path.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/FileRule", "prepareRulePath"));
            }
            return "";
        }
        String string = FileUtil.normalizeRelativePath(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/FileRule", "prepareRulePath"));
        }
        return string;
    }
}

