/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.FileRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeRule
extends FileRule<CheckoutRules> {
    private final String myTo;
    private final boolean myAbsolutePath;

    public IncludeRule(@NotNull String from, @NotNull String to, CheckoutRules parentRules) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "jetbrains/buildServer/vcs/IncludeRule", "<init>"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "jetbrains/buildServer/vcs/IncludeRule", "<init>"));
        }
        super(from, parentRules, true, false);
        this.myTo = this.preparePath(to);
        this.myAbsolutePath = to.startsWith("/");
    }

    public String getTo() {
        return this.myTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludeRule that = (IncludeRule)o;
        if (!this.myFromPath.equals(that.myFromPath)) {
            return false;
        }
        return this.myTo.equals(that.myTo);
    }

    public int hashCode() {
        int result = this.myFromPath.hashCode();
        result = 31 * result + this.myTo.hashCode();
        return result;
    }

    @Override
    @Nullable
    public String getMatchedHead(String path) {
        String rulePath = this.preparePath(path);
        if (this.myFromPath.length() == 0 || rulePath.equals(this.myFromPath) || rulePath.startsWith(this.myFromPath + "/")) {
            return this.myFromPath;
        }
        return null;
    }

    public static IncludeRule createDefaultInstance() {
        CheckoutRules checkoutRules = new CheckoutRules("");
        return (IncludeRule)checkoutRules.getIncludeRules().get(0);
    }

    @Override
    public String toString() {
        return this.getFrom() + "=>" + this.getTo();
    }

    public String toDescriptiveString() {
        return (this.myFromFull.length() == 0 ? "." : this.myFromFull) + "=>" + (this.myTo.length() == 0 ? "." : this.myTo);
    }

    @Nullable
    public String map(String path) {
        String to = IncludeRule.trimSlashes(this.getTo());
        String preparedPath = this.preparePath(path);
        String from = this.getMatchedHead(preparedPath);
        if (from == null) {
            return null;
        }
        from = IncludeRule.trimSlashes(from);
        String barePath = IncludeRule.trimSlashes(preparedPath.length() == from.length() ? "" : preparedPath.substring(from.length()));
        if (to.length() > 0) {
            if (barePath.length() > 0) {
                return to + "/" + barePath;
            }
            return to;
        }
        return barePath;
    }

    private static String trimSlashes(String string) {
        int start;
        if (string.length() == 0) {
            return string;
        }
        int end = string.length() - 1;
        for (start = 0; start < string.length() && string.charAt(start) == '/'; ++start) {
        }
        while (end >= start && string.charAt(end) == '/') {
            --end;
        }
        return string.substring(start, end + 1);
    }

    public String createFullPath(String relativeFileName) {
        if (this.myFromPath.length() == 0 || this.myFromPath.equals(".")) {
            return relativeFileName;
        }
        if (relativeFileName.length() == 0 || relativeFileName.equals(".")) {
            return this.myFromPath;
        }
        if (relativeFileName.startsWith("/") || relativeFileName.startsWith("\\")) {
            return this.myFromPath + relativeFileName;
        }
        return this.myFromPath + "/" + relativeFileName;
    }

    public boolean intersects(IncludeRule rule) {
        if (this.myTo.length() == 0 || rule.getTo().length() == 0) {
            return false;
        }
        return CheckoutRules.isSubDir(this.myTo, rule.getTo()) || CheckoutRules.isSubDir(rule.getTo(), this.myTo);
    }

    public boolean isAbsolutePathTo() {
        return this.myAbsolutePath;
    }
}

