/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.vcs.AbstractPatchBuilder;
import jetbrains.buildServer.vcs.CheckoutRules;
import jetbrains.buildServer.vcs.IncludeRule;
import jetbrains.buildServer.vcs.patches.PatchBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchBuilderFileNamesCorrector
extends AbstractPatchBuilder {
    private final FilePathConverter myDefaultMode;
    private FilePathConverter myMode;
    private final PatchBuilder myOriginal;

    public PatchBuilderFileNamesCorrector(PatchBuilder original) {
        this.myMode = this.myDefaultMode = new FilePathConverter(){

            public File convertRelativeFile(@NotNull File file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector$1", "convertRelativeFile"));
                }
                return PatchBuilderFileNamesCorrector.this.getPathInCurrentWorkingDirectory(file);
            }
        };
        this.myOriginal = original;
    }

    public void deleteFile(@NotNull File file, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "deleteFile"));
        }
        File converted = this.myMode.convertRelativeFile(file);
        if (converted != null) {
            this.myOriginal.deleteFile(converted, deleteParentDirectoryIfEmpty);
        }
    }

    public void setLastModified(@NotNull File currentRelativeFile, long time) throws IOException {
        if (currentRelativeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRelativeFile", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "setLastModified"));
        }
        File converted = this.myMode.convertRelativeFile(currentRelativeFile);
        if (converted != null) {
            this.myOriginal.setLastModified(converted, time);
        }
    }

    public void deleteDirectory(@NotNull File file, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "deleteDirectory"));
        }
        File converted = this.myMode.convertRelativeFile(file);
        if (converted != null) {
            this.myOriginal.deleteDirectory(converted, deleteParentDirectoryIfEmpty);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void changeOrCreateTextFile(@NotNull File localFile, String fileMode, @NotNull InputStream input, long length, byte[] byArray) throws IOException {
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "changeOrCreateTextFile"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "changeOrCreateTextFile"));
        }
        File converted = this.myMode.convertRelativeFile(localFile);
        if (converted != null) {
            void lineSeparator;
            this.myOriginal.changeOrCreateTextFile(converted, fileMode, input, length, (byte[])lineSeparator);
        } else {
            TCStreamUtil.skip(input, length);
        }
    }

    public void changeOrCreateBinaryFile(@NotNull File file, String fileMode, @NotNull InputStream input, long length) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "changeOrCreateBinaryFile"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "changeOrCreateBinaryFile"));
        }
        File converted = this.myMode.convertRelativeFile(file);
        if (converted != null) {
            this.myOriginal.changeOrCreateBinaryFile(converted, fileMode, input, length);
        } else {
            TCStreamUtil.skip(input, length);
        }
    }

    public void createDirectory(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "createDirectory"));
        }
        File converted = this.myMode.convertRelativeFile(file);
        if (converted != null) {
            this.myOriginal.createDirectory(converted);
        }
    }

    public void createBinaryFile(@NotNull File file, String fileMode, @NotNull InputStream input, long length) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "createBinaryFile"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "createBinaryFile"));
        }
        File converted = this.myMode.convertRelativeFile(file);
        if (converted != null) {
            this.myOriginal.createBinaryFile(converted, fileMode, input, length);
        } else {
            TCStreamUtil.skip(input, length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createTextFile(@NotNull File file, String fileMode, @NotNull InputStream input, long length, byte[] byArray) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "createTextFile"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "createTextFile"));
        }
        File converted = this.myMode.convertRelativeFile(file);
        if (converted != null) {
            void lineSeparator;
            this.myOriginal.createTextFile(converted, fileMode, input, length, (byte[])lineSeparator);
        } else {
            TCStreamUtil.skip(input, length);
        }
    }

    public void renameFile(@NotNull File file, @NotNull File newFile, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "renameFile"));
        }
        if (newFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFile", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "renameFile"));
        }
        File converted = this.myMode.convertRelativeFile(file);
        File newFileConverted = this.myMode.convertRelativeFile(newFile);
        if (converted != null && newFileConverted == null) {
            this.myOriginal.deleteFile(converted, deleteParentDirectoryIfEmpty);
        } else if (converted != null) {
            this.myOriginal.renameFile(converted, newFileConverted, deleteParentDirectoryIfEmpty);
        }
    }

    public void renameDirectory(@NotNull File file, @NotNull File newFile, boolean deleteParentDirectoryIfEmpty) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "renameDirectory"));
        }
        if (newFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFile", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "renameDirectory"));
        }
        File converted = this.myMode.convertRelativeFile(file);
        File newFileConverted = this.myMode.convertRelativeFile(newFile);
        if (converted != null && newFileConverted == null) {
            this.myOriginal.deleteDirectory(converted, deleteParentDirectoryIfEmpty);
        } else if (converted != null) {
            this.myOriginal.renameDirectory(converted, newFileConverted, deleteParentDirectoryIfEmpty);
        }
    }

    public void setWorkingMode_WithIncludeRule(final @NotNull IncludeRule includeRule) {
        if (includeRule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includeRule", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "setWorkingMode_WithIncludeRule"));
        }
        this.myMode = new FilePathConverter(){

            public File convertRelativeFile(@NotNull File file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector$2", "convertRelativeFile"));
                }
                String fullPath = includeRule.createFullPath(PatchBuilderFileNamesCorrector.this.getPathInCurrentWorkingDirectory(file).getPath());
                String resultPath = PatchBuilderFileNamesCorrector.convertRelativePath(fullPath, (CheckoutRules)includeRule.getParentRules());
                return resultPath == null ? null : new File(resultPath);
            }
        };
    }

    public void setWorkingMode_WithCheckoutRules(final @NotNull CheckoutRules checkoutRules) {
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "setWorkingMode_WithCheckoutRules"));
        }
        this.myMode = new FilePathConverter(){

            public File convertRelativeFile(@NotNull File file) throws IOException {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector$3", "convertRelativeFile"));
                }
                String pathname = PatchBuilderFileNamesCorrector.convertRelativePath(PatchBuilderFileNamesCorrector.this.getPathInCurrentWorkingDirectory(file).getPath(), checkoutRules);
                return pathname == null ? null : new File(pathname);
            }
        };
    }

    @Nullable
    private static String convertRelativePath(@NotNull String fullRepoPath, @NotNull CheckoutRules checkoutRules) {
        if (fullRepoPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullRepoPath", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "convertRelativePath"));
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/buildServer/vcs/PatchBuilderFileNamesCorrector", "convertRelativePath"));
        }
        IncludeRule mostSpecRule = (IncludeRule)checkoutRules.getIncludeRuleFor(fullRepoPath);
        if (mostSpecRule == null) {
            return null;
        }
        return mostSpecRule.map(fullRepoPath);
    }

    public void setWorkingMode_Default() {
        this.myMode = this.myDefaultMode;
    }

    private static interface FilePathConverter {
        @Nullable
        public File convertRelativeFile(@NotNull File var1) throws IOException;
    }
}

