/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.util.Hash;
import jetbrains.buildServer.util.StringUtils;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.impl.VcsRootImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsUtil {
    @NonNls
    public static final String VCS_NAME_PROP = "vcs";
    @NonNls
    public static final String VCS_ROOT_NAME_PROP = "teamcity:vcsRootName";
    @NonNls
    public static final String BRANCH_SPEC_PROP = "teamcity:branchSpec";
    @NonNls
    public static final String CHECKOUT_ROOT = "checkout-root";

    public static boolean areEquivalentRoots(@Nullable VcsRoot root1, @Nullable VcsRoot root2) {
        if (root1 == root2) {
            return true;
        }
        if (root1 == null || root2 == null) {
            return false;
        }
        if (!root1.getVcsName().equals(root2.getVcsName())) {
            return false;
        }
        return ((Object)root1.getProperties()).equals(root2.getProperties());
    }

    @NotNull
    public static Map<String, String> getVcsRootPublicProperties(@NotNull VcsRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/buildServer/vcs/VcsUtil", "getVcsRootPublicProperties"));
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, String> prop : root.getProperties().entrySet()) {
            String propName = prop.getKey();
            String propValue = prop.getValue();
            if (VcsUtil.isSecureProperty(propName)) continue;
            result.put(propName, propValue);
        }
        TreeMap<String, String> treeMap = result;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsUtil", "getVcsRootPublicProperties"));
        }
        return treeMap;
    }

    public static long getVcsRootPropertiesHash(@NotNull VcsRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/buildServer/vcs/VcsUtil", "getVcsRootPropertiesHash"));
        }
        Map<String, String> propsCopy = root.getProperties();
        propsCopy.remove(VCS_NAME_PROP);
        propsCopy.remove(VCS_ROOT_NAME_PROP);
        propsCopy.remove(BRANCH_SPEC_PROP);
        return Hash.calc(VcsUtil.propertiesToString(propsCopy, false));
    }

    @NotNull
    public static String getVcsRootPropertiesAsPresentableString(@NotNull VcsRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/buildServer/vcs/VcsUtil", "getVcsRootPropertiesAsPresentableString"));
        }
        Map<String, String> properties = VcsUtil.createFullVcsPropertiesMap(root);
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(key);
            builder.append('=');
            if (VcsUtil.isSecureProperty(key)) {
                builder.append("*****");
            } else {
                builder.append(properties.get(key));
            }
            builder.append("; ");
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsUtil", "getVcsRootPropertiesAsPresentableString"));
        }
        return string;
    }

    @NotNull
    public static String convertVcsRootToString(@NotNull VcsRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/buildServer/vcs/VcsUtil", "convertVcsRootToString"));
        }
        String string = VcsUtil.propertiesToString(VcsUtil.createFullVcsPropertiesMap(root), true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsUtil", "convertVcsRootToString"));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static VcsRoot convertStringToVcsRoot(long id, @NotNull String string) {
        void serialized;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "jetbrains/buildServer/vcs/VcsUtil", "convertStringToVcsRoot"));
        }
        VcsRootImpl vcsRootImpl = new VcsRootImpl(id, VcsUtil.stringToProperties((String)serialized));
        if (vcsRootImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsUtil", "convertStringToVcsRoot"));
        }
        return vcsRootImpl;
    }

    @NotNull
    private static Map<String, String> createFullVcsPropertiesMap(@NotNull VcsRoot root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/buildServer/vcs/VcsUtil", "createFullVcsPropertiesMap"));
        }
        TreeMap<String, String> properties = new TreeMap<String, String>(root.getProperties());
        properties.put(VCS_NAME_PROP, root.getVcsName());
        properties.put(VCS_ROOT_NAME_PROP, root.getName());
        TreeMap<String, String> treeMap = properties;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsUtil", "createFullVcsPropertiesMap"));
        }
        return treeMap;
    }

    @NotNull
    public static String getSimplifiedName(@NotNull VcsRoot vcsRoot) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "jetbrains/buildServer/vcs/VcsUtil", "getSimplifiedName"));
        }
        String string = StringUtils.replaceNonAlphaNumericChars(vcsRoot.getName(), '_');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsUtil", "getSimplifiedName"));
        }
        return string;
    }

    public static boolean isSecureProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "jetbrains/buildServer/vcs/VcsUtil", "isSecureProperty"));
        }
        return propertyName.startsWith("secure:");
    }

    @NotNull
    public static String propertiesToStringSecure(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/vcs/VcsUtil", "propertiesToStringSecure"));
        }
        String string = VcsUtil.propertiesToString(properties, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsUtil", "propertiesToStringSecure"));
        }
        return string;
    }

    @NotNull
    public static String propertiesToString(@NotNull Map<String, String> properties, boolean scrambleSecureProps) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/buildServer/vcs/VcsUtil", "propertiesToString"));
        }
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(VcsUtil.escapeStr(key));
            builder.append('=');
            String value = properties.get(key);
            if (scrambleSecureProps && VcsUtil.isSecureProperty(key)) {
                value = EncryptUtil.scramble(value);
            }
            builder.append(VcsUtil.escapeStr(value));
            builder.append('\n');
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsUtil", "propertiesToString"));
        }
        return string;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    private static String escapeStr(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int finalCount = VcsUtil.calcFinalEscapedStringCount(str);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 45;
                continue;
            }
            if (c == '\\') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 92;
                continue;
            }
            if (c == '=') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 95;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/vcs/VcsUtil", "calcFinalEscapedStringCount"));
        }
        int result = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\n') {
                result += 2;
                continue;
            }
            if (c == '\\') {
                result += 2;
                continue;
            }
            if (c == '=') {
                result += 2;
                continue;
            }
            ++result;
        }
        return result;
    }

    @NotNull
    public static Map<String, String> stringToProperties(String string) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(string, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            int sepIndex = s.indexOf(61);
            if (sepIndex < 0) continue;
            String propName = VcsUtil.unescapeStr(s.substring(0, sepIndex));
            String propValue = VcsUtil.unescapeStr(s.substring(sepIndex + 1));
            if (VcsUtil.isSecureProperty(propName)) {
                try {
                    propValue = EncryptUtil.unscramble(propValue);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            result.put(propName, propValue);
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/VcsUtil", "stringToProperties"));
        }
        return hashMap;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    private static String unescapeStr(@Nullable String name) {
        if (name == null) {
            return null;
        }
        int finalCount = VcsUtil.calcFinalUnescapedStringCount(name);
        int len = name.length();
        if (len == finalCount) {
            return name;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < len; ++i) {
            int c = name.charAt(i);
            if (c == 92 && i < len - 1) {
                char nextChar = name.charAt(i + 1);
                if (nextChar == '-') {
                    c = 10;
                    ++i;
                } else if (nextChar == '\\') {
                    c = 92;
                    ++i;
                } else if (nextChar == '_') {
                    c = 61;
                    ++i;
                }
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect unescaping for '" + name + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalUnescapedStringCount(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/vcs/VcsUtil", "calcFinalUnescapedStringCount"));
        }
        int result = 0;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char nextChar;
            char c = name.charAt(i);
            if (c == '\\' && i < len - 1 && ((nextChar = name.charAt(i + 1)) == '-' || nextChar == '_' || nextChar == '\\')) {
                ++i;
            }
            ++result;
        }
        return result;
    }
}

