/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.patches;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchStreamUtil {
    public void close(@Nullable Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void skip(@NotNull InputStream input, long size) throws IOException {
        long numSkipped;
        long skipped;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/vcs/patches/PatchStreamUtil", "skip"));
        }
        long prevSkipped = -1L;
        for (numSkipped = 0L; numSkipped < size && ((skipped = input.skip(size - numSkipped)) != 0L || prevSkipped != 0L); numSkipped += skipped) {
            prevSkipped = skipped;
        }
        if (numSkipped < size) {
            int read;
            byte[] buffer = PatchStreamUtil.getByteBuffer();
            while (numSkipped < size && (read = input.read(buffer, 0, (int)Math.min((long)buffer.length, size - numSkipped))) != -1) {
                numSkipped += (long)read;
            }
        }
        if (numSkipped < size) {
            throw new EOFException("Not enough data in the stream to skip, requested: " + size + ", but skipped: " + numSkipped);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBinary(@NotNull InputStream input, long length, @NotNull OutputStream outputStream) throws IOException {
        int lastRead;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/vcs/patches/PatchStreamUtil", "writeBinary"));
        }
        if (outputStream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "jetbrains/buildServer/vcs/patches/PatchStreamUtil", "writeBinary"));
        }
        byte[] buffer = PatchStreamUtil.getByteBuffer();
        for (long read = 0L; read < length; read += (long)lastRead) {
            void output;
            lastRead = input.read(buffer, 0, (int)Math.min((long)buffer.length, length - read));
            if (lastRead == -1) {
                throw new EOFException();
            }
            output.write(buffer, 0, lastRead);
        }
    }

    private static byte[] getByteBuffer() {
        return new byte[8192];
    }
}

