/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.vcs.api;

import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.impl.VcsRootImpl;
import jetbrains.vcs.api.data.VcsDataObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsSettings
implements Loggable,
VcsDataObject {
    @NotNull
    private final VcsRoot myVcsRoot;
    @NotNull
    private final String myCheckoutRules;
    @NotNull
    private final Map<String, String> mySshKeys;

    public VcsSettings(@NotNull VcsRoot vcsRoot, @NotNull String checkoutRules) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        this(vcsRoot, checkoutRules, new HashMap<String, String>());
    }

    public VcsSettings(@NotNull VcsRoot vcsRoot, @NotNull String checkoutRules, @NotNull Map<String, String> sshKeys) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (sshKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sshKeys", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        this.myVcsRoot = vcsRoot;
        this.myCheckoutRules = checkoutRules;
        this.mySshKeys = sshKeys;
    }

    /*
     * WARNING - void declaration
     */
    public VcsSettings(long settingsId, @NotNull String vcsName, @Nullable String displayName, @NotNull String checkoutRules, @NotNull Map<String, String> map) {
        void properties;
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        VcsRootImpl vcsRoot = new VcsRootImpl(settingsId, vcsName, (Map<String, String>)properties);
        if (displayName != null) {
            vcsRoot.setName(displayName);
        }
        this.myVcsRoot = vcsRoot;
        this.myCheckoutRules = checkoutRules;
        this.mySshKeys = new HashMap<String, String>();
    }

    /*
     * WARNING - void declaration
     */
    public VcsSettings(long settingsId, @NotNull String vcsName, @Nullable String displayName, @NotNull String checkoutRules, @NotNull Map<String, String> properties, @NotNull Map<String, String> map) {
        void sshKeys;
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        VcsRootImpl vcsRoot = new VcsRootImpl(settingsId, vcsName, properties);
        if (displayName != null) {
            vcsRoot.setName(displayName);
        }
        this.myVcsRoot = vcsRoot;
        this.myCheckoutRules = checkoutRules;
        this.mySshKeys = sshKeys;
    }

    @NotNull
    public VcsRoot getVcsRoot() {
        VcsRoot vcsRoot = this.myVcsRoot;
        if (vcsRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "getVcsRoot"));
        }
        return vcsRoot;
    }

    public long getSettingsId() {
        return this.myVcsRoot.getId();
    }

    @Nullable
    public String getDisplayName() {
        return this.myVcsRoot.getName();
    }

    @NotNull
    public String getVcsName() {
        String string = this.myVcsRoot.getVcsName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "getVcsName"));
        }
        return string;
    }

    @NotNull
    public Map<String, String> getProperties() {
        Map<String, String> map = this.myVcsRoot.getProperties();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "getProperties"));
        }
        return map;
    }

    @NotNull
    public Map<String, String> getSshKeys() {
        Map<String, String> map = this.mySshKeys;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "getSshKeys"));
        }
        return map;
    }

    @NotNull
    public String getCheckoutRulesSpecification() {
        String string = this.myCheckoutRules;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "getCheckoutRulesSpecification"));
        }
        return string;
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        String string = "VcsSettings[" + this.myVcsRoot.describe(verbose) + "; Checkout rules: " + this.myCheckoutRules + "]";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "describe"));
        }
        return string;
    }

    public String toString() {
        return this.describe(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VcsSettings)) {
            return false;
        }
        VcsSettings that = (VcsSettings)o;
        return this.myCheckoutRules.equals(that.myCheckoutRules) && this.myVcsRoot.equals(that.myVcsRoot);
    }

    public int hashCode() {
        int result = this.myVcsRoot.hashCode();
        result = 31 * result + this.myCheckoutRules.hashCode();
        return result;
    }
}

