/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.AuthDemo;
import org.apache.xmlrpc.AuthenticationFailed;
import org.apache.xmlrpc.Echo;
import org.apache.xmlrpc.ServerInputStream;
import org.apache.xmlrpc.SystemHandler;
import org.apache.xmlrpc.TCXmlRpcServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcServer;

public class WebServer2
implements Runnable {
    protected XmlRpcServer xmlrpc;
    protected ServerSocketWrapper serverSocket;
    protected Thread listener;
    protected Vector accept;
    protected Vector deny;
    protected Stack threadpool;
    protected final ArrayList workers = new ArrayList();
    protected final ArrayList myHandlerNames = new ArrayList();
    private InetAddress address;
    private int port;
    private boolean paranoid;
    protected static final byte[] ctype = WebServer2.toHTTPBytes("Content-Type: text/xml\r\n");
    protected static final byte[] clength = WebServer2.toHTTPBytes("Content-Length: ");
    protected static final byte[] newline = WebServer2.toHTTPBytes("\r\n");
    protected static final byte[] doubleNewline = WebServer2.toHTTPBytes("\r\n\r\n");
    protected static final byte[] conkeep = WebServer2.toHTTPBytes("Connection: Keep-Alive\r\n");
    protected static final byte[] conclose = WebServer2.toHTTPBytes("Connection: close\r\n");
    protected static final byte[] ok = WebServer2.toHTTPBytes(" 200 OK\r\n");
    protected static final byte[] server = WebServer2.toHTTPBytes("Server: Apache XML-RPC 1.0\r\n");
    protected static final byte[] wwwAuthenticate = WebServer2.toHTTPBytes("WWW-Authenticate: Basic realm=XML-RPC\r\n");
    private static final String HTTP_11 = "HTTP/1.1";
    private static final String STAR = "*";
    private volatile boolean myShutdown = false;
    private final Collection myRunnerThreads = new HashSet();
    private boolean myKeepAlive = XmlRpc.getKeepAlive();
    private int mySocketReadTimeout = 30000;
    private final Logger myLogger = Logger.getLogger((Class)XmlRpc.class);

    public static WebServer2 createStartedServer(int initialPort, XmlRpcServer xmlrpc) {
        WebServer2 ws = new WebServer2(xmlrpc);
        ws.start(initialPort);
        return ws;
    }

    public void setSocketReadTimeout(int timeout) {
        this.mySocketReadTimeout = timeout;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    private WebServer2(XmlRpcServer xmlrpc) {
        this.xmlrpc = xmlrpc == null ? new TCXmlRpcServer() : xmlrpc;
        this.accept = new Vector();
        this.deny = new Vector();
        this.threadpool = new Stack();
    }

    protected static byte[] toHTTPBytes(String text) {
        try {
            return text.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage() + ": HTTP requires US-ASCII encoding");
        }
    }

    private void setupServerSocket(ServerSocket boundSocket) throws Exception {
        this.serverSocket = new ServerSocketWrapper(boundSocket);
        try {
            this.address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            this.myLogger.warn((Object)("Failed to get localhost: " + e.getMessage()), (Throwable)e);
            this.address = null;
        }
        this.port = boundSocket.getLocalPort();
        if (XmlRpc.debug) {
            StringBuffer msg = new StringBuffer();
            msg.append("Opened XML-RPC server socket for ");
            msg.append(this.address != null ? this.address.getHostName() : "localhost");
            msg.append(':').append(this.port);
            this.myLogger.debug((Object)msg.toString());
        }
        if (this.serverSocket.getSoTimeout() <= 0) {
            this.serverSocket.setSoTimeout(4096);
        }
    }

    private void start(int initialPort) {
        this.myShutdown = false;
        try {
            this.setupServerSocket(WebServer2.createServerSocketOnFreePort(initialPort));
        }
        catch (Exception e) {
            this.listener = null;
            this.myLogger.warn((Object)e);
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.listener == null) {
            this.listener = new Thread((Runnable)this, "XML-RPC Weblistener");
            this.listener.start();
        }
    }

    public void setKeepAlive(boolean keepAlive) {
        this.myKeepAlive = keepAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(String name, Object target) {
        this.xmlrpc.addHandler(name, target);
        ArrayList arrayList = this.myHandlerNames;
        synchronized (arrayList) {
            this.myHandlerNames.add(name);
        }
    }

    protected void addDefaultHandlers() throws Exception {
        this.addHandler("string", "Welcome to XML-RPC!");
        this.addHandler("math", Math.class);
        this.addHandler("auth", new AuthDemo());
        this.addHandler("$default", new Echo());
        String url = "http://www.mailtothefuture.com:80/RPC2";
        this.addHandler("mttf", new XmlRpcClient(url));
        SystemHandler system = new SystemHandler();
        system.addDefaultSystemHandlers();
        this.addHandler("system", system);
    }

    public void removeHandler(String name) {
        this.xmlrpc.removeHandler(name);
    }

    public void setParanoid(boolean p) {
        this.paranoid = p;
    }

    public void acceptClient(String address) throws IllegalArgumentException {
        try {
            AddressMatcher m = new AddressMatcher(address);
            this.accept.addElement(m);
        }
        catch (Exception x) {
            throw new IllegalArgumentException("\"" + address + "\" does not represent a valid IP address");
        }
    }

    public void denyClient(String address) throws IllegalArgumentException {
        try {
            AddressMatcher m = new AddressMatcher(address);
            this.deny.addElement(m);
        }
        catch (Exception x) {
            throw new IllegalArgumentException("\"" + address + "\" does not represent a valid IP address");
        }
    }

    protected boolean allowConnection(Socket s) {
        AddressMatcher match;
        int i;
        if (this.myShutdown) {
            return false;
        }
        if (!this.paranoid) {
            return true;
        }
        int l = this.deny.size();
        byte[] address = s.getInetAddress().getAddress();
        for (i = 0; i < l; ++i) {
            match = (AddressMatcher)this.deny.elementAt(i);
            if (!match.matches(address)) continue;
            return false;
        }
        l = this.accept.size();
        for (i = 0; i < l; ++i) {
            match = (AddressMatcher)this.accept.elementAt(i);
            if (!match.matches(address)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkSocket(Socket s) {
        return this.allowConnection(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block56: {
            try {
                try {
                    while (this.listener != null) {
                        block55: {
                            block54: {
                                socket = null;
                                runner = null;
                                try {
                                    try {
                                        if (this.serverSocket.isClosed()) {
                                            var5_10 = null;
                                            if (runner != null || socket == null) break;
                                            break block54;
                                        }
                                        try {
                                            socket = this.serverSocket.accept();
                                        }
                                        catch (SocketException e) {
                                            if (!this.myShutdown) {
                                                System.err.println("Exception occurred in accept() method: " + e.toString());
                                                e.printStackTrace();
                                                this.myLogger.warn((Object)e);
                                            }
                                            var5_10 = null;
                                            if (runner != null || socket == null) break;
                                            try {
                                                socket.close();
                                            }
                                            catch (Throwable e) {}
                                            break;
                                        }
                                        try {
                                            socket.setTcpNoDelay(true);
                                        }
                                        catch (SocketException socketOptEx) {
                                            this.myLogger.warn((Object)socketOptEx);
                                            System.err.println(socketOptEx);
                                        }
                                        if (this.allowConnection(socket)) {
                                            runner = this.getRunner();
                                            runner.handle(socket);
                                            break block55;
                                        } else {
                                            socket.close();
                                        }
                                        break block55;
                                    }
                                    catch (InterruptedIOException checkState) {
                                        var5_10 = null;
                                        if (runner != null || socket == null) continue;
                                        try {}
                                        catch (Throwable e) {}
                                        socket.close();
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        System.err.println("Exception in XML-RPC listener loop (" + ex + ").");
                                        ex.printStackTrace();
                                        this.myLogger.warn((Object)ex);
                                        var5_10 = null;
                                        if (runner != null || socket == null) continue;
                                        try {}
                                        catch (Throwable e) {}
                                        socket.close();
                                        continue;
                                    }
                                    catch (Error err) {
                                        System.err.println("Error in XML-RPC listener loop (" + err + ").");
                                        err.printStackTrace();
                                        this.myLogger.warn((Object)err);
                                        var5_10 = null;
                                        if (runner != null || socket == null) continue;
                                        try {}
                                        catch (Throwable e) {}
                                        socket.close();
                                        continue;
                                    }
                                }
                                catch (Throwable var4_12) {
                                    var5_10 = null;
                                    if (runner != null) throw var4_12;
                                    if (socket == null) throw var4_12;
                                    ** try [egrp 6[TRYBLOCK] [18 : 270->277)] { 
lbl80:
                                    // 1 sources

                                    socket.close();
                                    throw var4_12;
lbl82:
                                    // 1 sources

                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                    throw var4_12;
                                }
                            }
                            try {}
                            catch (Throwable e) {}
                            socket.close();
                            break;
                        }
                        var5_10 = null;
                        if (runner != null || socket == null) continue;
                        try {}
                        catch (Throwable e) {}
                        socket.close();
                    }
                    var8_13 = null;
                    if (this.serverSocket == null) break block56;
                }
                catch (Exception exception) {
                    System.err.println("Error accepting XML-RPC connections (" + exception + ").");
                    this.myLogger.warn((Object)exception);
                    if (XmlRpc.debug) {
                        exception.printStackTrace();
                    }
                    var8_14 = null;
                    if (this.serverSocket != null) {
                        try {
                            if (!this.serverSocket.isClosed()) {
                                this.serverSocket.close();
                                if (this.myLogger.isDebugEnabled()) {
                                    this.myLogger.debug((Object)"Closed XML-RPC server socket");
                                }
                            }
                            this.serverSocket = null;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    var9_17 = this.workers;
                    synchronized (var9_17) {
                        it = this.workers.iterator();
                        while (it.hasNext() != false) {
                            thread = (Thread)it.next();
                            if (!thread.isAlive()) {
                                it.remove();
                                continue;
                            }
                            try {
                                thread.interrupt();
                            }
                            catch (Throwable e) {
                                this.myLogger.error((Object)("Error interrupting thread: " + e.toString()));
                                this.myLogger.debug((Object)e.getMessage(), e);
                            }
                        }
                        return;
                    }
                }
            }
            catch (Throwable var7_28) {
                block59: {
                    var8_15 = null;
                    if (this.serverSocket != null) {
                        ** try [egrp 7[TRYBLOCK] [23 : 362->406)] { 
lbl141:
                        // 1 sources

                        if (!this.serverSocket.isClosed()) {
                            this.serverSocket.close();
                            if (this.myLogger.isDebugEnabled()) {
                                this.myLogger.debug((Object)"Closed XML-RPC server socket");
                            }
                        }
                        this.serverSocket = null;
                        break block59;
lbl147:
                        // 1 sources

                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                var9_18 = this.workers;
                synchronized (var9_18) {
                    it = this.workers.iterator();
                    while (it.hasNext() != false) {
                        thread = (Thread)it.next();
                        if (!thread.isAlive()) {
                            it.remove();
                            continue;
                        }
                        ** try [egrp 9[TRYBLOCK] [24 : 470->478)] { 
lbl159:
                        // 1 sources

                        thread.interrupt();
lbl161:
                        // 1 sources

                        catch (Throwable e) {
                            this.myLogger.error((Object)("Error interrupting thread: " + e.toString()));
                            this.myLogger.debug((Object)e.getMessage(), e);
                        }
                    }
                    throw var7_28;
                }
            }
            ** try [egrp 7[TRYBLOCK] [23 : 362->406)] { 
lbl168:
            // 1 sources

            if (!this.serverSocket.isClosed()) {
                this.serverSocket.close();
                if (this.myLogger.isDebugEnabled()) {
                    this.myLogger.debug((Object)"Closed XML-RPC server socket");
                }
            }
            this.serverSocket = null;
            break block56;
lbl174:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
        }
        var9_16 = this.workers;
        synchronized (var9_16) {
            it = this.workers.iterator();
            while (it.hasNext() != false) {
                thread = (Thread)it.next();
                if (!thread.isAlive()) {
                    it.remove();
                    continue;
                }
                try {}
                catch (Throwable e) {
                    this.myLogger.error((Object)("Error interrupting thread: " + e.toString()));
                    this.myLogger.debug((Object)e.getMessage(), e);
                    continue;
                }
                thread.interrupt();
            }
            return;
        }
    }

    public synchronized void shutdown() {
        this.myShutdown = true;
        this.stopAcceptingConnectionsAndCloseServerSocket();
        this.closeWorkingConnections();
        this.unregisterHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterHandlers() {
        ArrayList handlers = new ArrayList();
        ArrayList arrayList = this.myHandlerNames;
        synchronized (arrayList) {
            handlers.addAll(this.myHandlerNames);
            this.myHandlerNames.clear();
        }
        int myHandlerNamesSize = handlers.size();
        for (int i = 0; i < myHandlerNamesSize; ++i) {
            this.xmlrpc.removeHandler((String)handlers.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWorkingConnections() {
        while (true) {
            int aliveThreads = 0;
            Collection collection = this.myRunnerThreads;
            synchronized (collection) {
                Iterator it = this.myRunnerThreads.iterator();
                while (it.hasNext()) {
                    Runner runner = (Runner)it.next();
                    Thread t = runner.thread;
                    if (!t.isAlive()) continue;
                    t.interrupt();
                    try {
                        runner.con.socket.shutdownInput();
                        runner.con.socket.shutdownOutput();
                        runner.con.socket.close();
                    }
                    catch (NullPointerException e) {
                    }
                    catch (Throwable e) {
                        this.myLogger.debug((Object)e.toString(), e);
                    }
                    ++aliveThreads;
                }
            }
            if (aliveThreads == 0) {
                return;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void stopAcceptingConnectionsAndCloseServerSocket() {
        Thread l;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((l = this.listener) != null) {
            this.listener = null;
            l.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runner getRunner() {
        try {
            return (Runner)this.threadpool.pop();
        }
        catch (EmptyStackException empty) {
            int size;
            int maxRequests = XmlRpc.getMaxThreads();
            ArrayList arrayList = this.workers;
            synchronized (arrayList) {
                size = this.workers.size();
            }
            if (size > XmlRpc.getMaxThreads()) {
                throw new RuntimeException("System overload: Maximum number of concurrent requests (" + maxRequests + ") exceeded");
            }
            return new Runner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repoolRunner(Runner runner) {
        this.threadpool.push(runner);
        Collection collection = this.myRunnerThreads;
        synchronized (collection) {
            this.myRunnerThreads.remove(runner);
        }
    }

    private static ServerSocket createServerSocketOnFreePort(int startFromPort) {
        int numIterations = 0;
        int port = startFromPort;
        try {
            while (numIterations < 3) {
                if (!WebServer2.isPortBusy("127.0.0.1", port, 20)) {
                    try {
                        return new ServerSocket(port, 50, null);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (++port > 65535) {
                    port = startFromPort;
                    ++numIterations;
                }
                Thread.sleep(30L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while finding for free port: " + e.toString());
        }
        throw new RuntimeException("Unable to find free port to open server socket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isPortBusy(String host, int port, int connectTimeoutMsecs) {
        Socket socket = null;
        socket = new Socket();
        socket.connect(new InetSocketAddress(host, port), connectTimeoutMsecs);
        Object var7_4 = null;
        if (socket == null) return true;
        try {
            socket.close();
            return true;
        }
        catch (IOException e2) {}
        return true;
        {
            catch (IOException e) {
                boolean bl = false;
                Object var7_5 = null;
                if (socket == null) return bl;
                try {
                    socket.close();
                    return bl;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (socket == null) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static class ServerSocketWrapper {
        private boolean myClosed;
        private final ServerSocket mySocket;

        public ServerSocketWrapper(ServerSocket origSocket) {
            this.mySocket = origSocket;
        }

        public void close() throws IOException {
            this.mySocket.close();
            this.myClosed = true;
        }

        public boolean isClosed() {
            return this.myClosed;
        }

        public Socket accept() throws IOException {
            return this.mySocket.accept();
        }

        public void setSoTimeout(int timeout) throws SocketException {
            this.mySocket.setSoTimeout(timeout);
        }

        public int getSoTimeout() throws IOException {
            return this.mySocket.getSoTimeout();
        }
    }

    class AddressMatcher {
        int[] pattern = new int[4];

        public AddressMatcher(String address) throws Exception {
            StringTokenizer st = new StringTokenizer(address, ".");
            if (st.countTokens() != 4) {
                throw new Exception("\"" + address + "\" does not represent a valid IP address");
            }
            for (int i = 0; i < 4; ++i) {
                String next = st.nextToken();
                this.pattern[i] = WebServer2.STAR.equals(next) ? 256 : (int)((byte)Integer.parseInt(next));
            }
        }

        public boolean matches(byte[] address) {
            for (int i = 0; i < 4; ++i) {
                if (this.pattern[i] > 255 || this.pattern[i] == address[i]) continue;
                return false;
            }
            return true;
        }
    }

    class Connection
    implements Runnable {
        Socket socket;
        private final BufferedInputStream input;
        private final BufferedOutputStream output;
        private String user;
        private String password;
        byte[] buffer;

        public Connection(Socket socket) throws IOException {
            socket.setSoTimeout(WebServer2.this.mySocketReadTimeout);
            this.socket = socket;
            this.input = new BufferedInputStream(socket.getInputStream());
            this.output = new BufferedOutputStream(socket.getOutputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                boolean keepAlive = false;
                do {
                    this.user = null;
                    this.password = null;
                    String line = this.readLine();
                    if (line != null && line.length() == 0) {
                        line = this.readLine();
                    }
                    if (WebServer2.this.myLogger.isDebugEnabled()) {
                        WebServer2.this.myLogger.debug((Object)line);
                    }
                    int contentLength = -1;
                    StringTokenizer tokens = new StringTokenizer(line);
                    String method = tokens.nextToken();
                    String uri = tokens.nextToken();
                    String httpVersion = tokens.nextToken();
                    boolean bl = keepAlive = WebServer2.this.myKeepAlive && WebServer2.HTTP_11.equals(httpVersion);
                    do {
                        String lineLower;
                        if ((line = this.readLine()) == null) continue;
                        if (WebServer2.this.myLogger.isDebugEnabled()) {
                            WebServer2.this.myLogger.debug((Object)line);
                        }
                        if ((lineLower = line.toLowerCase()).startsWith("content-length:")) {
                            contentLength = Integer.parseInt(line.substring(15).trim());
                        }
                        if (lineLower.startsWith("connection:")) {
                            boolean bl2 = keepAlive = WebServer2.this.myKeepAlive && lineLower.indexOf("keep-alive") > -1;
                        }
                        if (!lineLower.startsWith("authorization: basic ")) continue;
                        this.parseAuth(line);
                    } while (line != null && line.length() != 0 && !WebServer2.this.myShutdown);
                    if (WebServer2.this.myShutdown) {
                        keepAlive = false;
                        this.writeShutdownInProgress(httpVersion);
                    } else if ("POST".equalsIgnoreCase(method)) {
                        ServerInputStream sin = new ServerInputStream(this.input, contentLength);
                        try {
                            byte[] result = WebServer2.this.xmlrpc.execute((InputStream)sin, this.user, this.password);
                            this.writeResponse(result, httpVersion, keepAlive);
                        }
                        catch (AuthenticationFailed unauthorized) {
                            keepAlive = false;
                            this.writeUnauthorized(httpVersion, method);
                        }
                    } else {
                        keepAlive = false;
                        this.writeBadRequest(httpVersion, method);
                    }
                    this.output.flush();
                } while (keepAlive && !WebServer2.this.myShutdown);
            }
            catch (NoSuchElementException exception) {
                WebServer2.this.myLogger.debug((Object)exception.getMessage(), (Throwable)exception);
            }
            catch (SocketException exception) {
                WebServer2.this.myLogger.debug((Object)exception.getMessage(), (Throwable)exception);
            }
            catch (Exception exception) {
                WebServer2.this.myLogger.warn((Object)exception.getMessage(), (Throwable)exception);
            }
            finally {
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException ignore) {}
            }
        }

        private String readLine() throws IOException {
            int next;
            if (this.buffer == null) {
                this.buffer = new byte[2048];
            }
            int count = 0;
            while (!WebServer2.this.myShutdown && (next = this.input.read()) >= 0 && next != 10) {
                if (next != 13) {
                    this.buffer[count++] = (byte)next;
                }
                if (count < this.buffer.length) continue;
                throw new IOException("HTTP Header too long");
            }
            return new String(this.buffer, 0, count, "ISO-8859-1");
        }

        private synchronized void parseAuth(String line) {
            try {
                Base64 base64Codec = new Base64();
                byte[] c = base64Codec.decode(WebServer2.toHTTPBytes(line.substring(21)));
                String str = new String(c, "ISO-8859-1");
                int col = str.indexOf(58);
                this.user = str.substring(0, col);
                this.password = str.substring(col + 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void writeResponse(byte[] payload, String httpVersion, boolean keepAlive) throws IOException {
            this.output.write(WebServer2.toHTTPBytes(httpVersion));
            this.output.write(ok);
            this.output.write(server);
            this.output.write(keepAlive ? conkeep : conclose);
            this.output.write(ctype);
            this.output.write(clength);
            this.output.write(WebServer2.toHTTPBytes(Integer.toString(payload.length)));
            this.output.write(doubleNewline);
            this.output.write(payload);
        }

        private void writeBadRequest(String httpVersion, String httpMethod) throws IOException {
            this.output.write(WebServer2.toHTTPBytes(httpVersion));
            this.output.write(WebServer2.toHTTPBytes(" 400 Bad Request"));
            this.output.write(newline);
            this.output.write(server);
            this.output.write(newline);
            this.output.write(WebServer2.toHTTPBytes("Method " + httpMethod + " not implemented (try POST)"));
        }

        private void writeShutdownInProgress(String httpVersion) throws IOException {
            this.output.write(WebServer2.toHTTPBytes(httpVersion));
            this.output.write(WebServer2.toHTTPBytes(" 403 Forbidden"));
            this.output.write(newline);
            this.output.write(server);
            this.output.write(newline);
            this.output.write(WebServer2.toHTTPBytes("Shutdown in progress"));
        }

        private void writeUnauthorized(String httpVersion, String httpMethod) throws IOException {
            this.output.write(WebServer2.toHTTPBytes(httpVersion));
            this.output.write(WebServer2.toHTTPBytes(" 401 Unauthorized"));
            this.output.write(newline);
            this.output.write(server);
            this.output.write(wwwAuthenticate);
            this.output.write(newline);
            this.output.write(WebServer2.toHTTPBytes("Method " + httpMethod + " requires a " + "valid user name and password"));
        }
    }

    class Runner
    implements Runnable {
        Thread thread;
        Connection con;
        int count;

        Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void handle(Socket socket) throws IOException {
            this.con = new Connection(socket);
            this.count = 0;
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread((Runnable)this, "XML-RPC Worker");
                ArrayList arrayList = WebServer2.this.workers;
                synchronized (arrayList) {
                    WebServer2.this.workers.add(this.thread);
                }
                this.thread.start();
            } else {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            try {
                while (this.con != null) {
                    if (Thread.currentThread() != this.thread) return;
                    if (WebServer2.this.myShutdown) return;
                    object = WebServer2.this.myRunnerThreads;
                    synchronized (object) {
                        WebServer2.this.myRunnerThreads.add(this);
                    }
                    this.con.run();
                    ++this.count;
                    this.con = null;
                    if (this.count > 200) return;
                    if (WebServer2.this.threadpool.size() > 20) {
                        return;
                    }
                    object = this;
                    synchronized (object) {
                        WebServer2.this.repoolRunner(this);
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ir) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                return;
            }
            finally {
                object = WebServer2.this.workers;
                synchronized (object) {
                    WebServer2.this.workers.remove(Thread.currentThread());
                }
                object = WebServer2.this.myRunnerThreads;
                synchronized (object) {
                    WebServer2.this.myRunnerThreads.remove(this);
                }
            }
        }
    }
}

